# -*- coding: utf-8 -*-

__author__ = 'Ruslan Keba <ruslan@helicontech.com>'

import tornado.httpserver
import tornado.ioloop
import tornado.options
import tornado.web
from tornado.options import define, options

define("port", default=8888, help="run on the given port", type=int)

class Application(tornado.web.Application):
    def __init__(self):
        handlers = [
            (r"/.*", HomeHandler),
        ]
        settings = dict(
            debug=True,
        )
        self.debug = True
        tornado.web.Application.__init__(self, handlers, **settings)

class HomeHandler(tornado.web.RequestHandler):
    def get(self):
        self.set_header("Content-Type", "text/plain")
        self.write("Hello from Tornado!\n")
        self.write("\nRequest headers:\n")
        for header in self.request.headers:
            self.write('{0}: {1}\n'.format(header, self.request.headers[header]))
        self.finish()


def main():
    tornado.options.parse_command_line()
    http_server = tornado.httpserver.HTTPServer(Application())
    http_server.listen(options.port)
    tornado.ioloop.IOLoop.instance().start()

if __name__ == "__main__":
    main()
