# This file is example of deploy.py
#
# Path to this file is configured in web.config:
#      <application name="django.project.x86" >
#        <environmentVariables>
#          <add name="DEPLOY_FILE" value="deploy.py" />
#          <add name="DEPLOY_LOG"  value="log\deploy.log" />
#        </environmentVariables>
#      </application>
#
# The file is executed once on the first request after every restart of IIS application.
# The file output is redirected to log file described in DEPLOG_LOG environment variable.
#

import sys
import os
import os.path
import shutil

PROJECT_DIR = os.path.dirname(__file__)
os.chdir(PROJECT_DIR)
PYTHON_MODULES_DIR = 'python_modules'

PIP_EXE = os.path.join(os.path.dirname(sys.executable), 'scripts\\pip.exe')

# update APPDATA env for pip
os.environ['APPDATA'] = os.path.join(PROJECT_DIR, PYTHON_MODULES_DIR)

# install requirements to local folder
os.system('{0} install --install-option="--prefix={1}" --build={2} --requirement=requirements.txt'.format(
            PIP_EXE, 
            os.path.join(PROJECT_DIR, PYTHON_MODULES_DIR),
            os.path.join(PROJECT_DIR, PYTHON_MODULES_DIR, '_build'),
            ))

# that's all
print "Bye!"
